/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

//#include <stdio.h>
//#include <stdlib.h>
// #include <string.h>
#include "tclib.h"
#include "tstutils.h"
#include "drmutilities.h"
#include "drmpkcrypto.h"
#include "drmcontextsizes.h"
#include "drmsecurestore.h"
#include "tOEMIMP.h"
#include "drmcrt.h"
 


#define MAX_CONTEXT_NUM	5
/*global variables*/
static DRM_SECSTORE_CONTEXT g_oContext[MAX_CONTEXT_NUM];
static DRM_HDS_CONTEXT *g_pHdsContext = NULL;
static DRM_SECSTOREENUM_CONTEXT g_oSecEnumContext;
static DRM_BYTE g_szSecStorePassword[SHA_DIGEST_LEN]={0};
 
  
DRM_RESULT TestDRM_SST_Initialize(long iIndex, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	int i=0;

	if (argv!=NULL){
		iIndex=(int)OEM_atoi(argv[0]);
	}
	if(iIndex==0 ||iIndex==1){ 
		for(i=0; i<MAX_CONTEXT_NUM; i++){
			DX_VOS_MemSet(&g_oContext[i], 0, sizeof(g_oContext[i])); 
		}
 	}
 	if(iIndex==0 ||iIndex==2){ 
		DX_VOS_MemSet(&g_oSecEnumContext, 0, sizeof(g_oSecEnumContext)); 
	}
   	if(iIndex==20)
		RemoveDRMFile(RMFILE_STORE); /*delete store*/
 	return dr;
}

DRM_RESULT TestDRM_SST_GetData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL,Key2, *pKey2=NULL;
	DRM_BYTE *pbPassword=NULL;
 	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iContextNull=0, iHDSContextNull=0, iSizeNull=0;
	DRM_DWORD cbData=0;
	DRM_BYTE *pbData=NULL;

	/*at least 9 arguments.*/  
 	if(argc<9){
		Log("Trace", "\t\tFrom TestDRM_SST_GetData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
   
  	if(argv[0]==NULL)
 		iContextNull=1;
 
 	if(argv[1]!=NULL){
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[1], min(DX_VOS_StrLen(argv[1]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

 	if(argv[2]!=NULL){
		DX_VOS_MemSet(Key2.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key2.rgb, argv[2], min(DX_VOS_StrLen(argv[2]) + 1, DRM_ID_SIZE));
		pKey2 = &Key2;
	} 

 	if(argv[3]!=NULL){
 		pbPassword=(DRM_BYTE*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[3])+1);
		if(!pbPassword)
			ChkDR(DRM_E_FAIL);
		DX_VOS_FastMemCpy(pbPassword, argv[3],DX_VOS_StrLen(argv[3])+1);			 
	} 

 	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atol(argv[4]);
  
	if(argv[5]==NULL)
 		iHDSContextNull=1;
 
 	if(argv[6]!=NULL){
		cbData=DX_VOS_StrLen(argv[6])+1;
 		ChkMem(pbData=(DRM_BYTE*)DX_VOS_MemMalloc(cbData));
	 	DX_VOS_FastMemCpy(pbData, argv[6], cbData);
	}
	if(argv[7]==NULL)
		iSizeNull=1;

	dr=DRM_SST_GetData(iContextNull>0?NULL:&g_oContext[0], pKey1,pKey2, pbPassword, iSecType, iHDSContextNull>0?NULL:g_pHdsContext,pbData, iSizeNull>0?NULL:&cbData);
 	if (dr==DRM_E_BUFFERTOOSMALL){
		DX_VOS_MemFree(pbData);
		ChkMem(pbData = DX_VOS_MemMalloc(cbData + 1));
	}
	else{
		ChkDR(dr);
	}

	ChkDR(DRM_SST_GetData(iContextNull>0?NULL:&g_oContext[0], pKey1,pKey2, pbPassword, iSecType, iHDSContextNull>0?NULL:g_pHdsContext,pbData, &cbData));
  
	/*verify the data*/
	if(argv[8]!=NULL){
		if(DX_VOS_StrNCmp((char*)pbData,argv[8], DX_VOS_StrLen(argv[8]))){
			ChkDR(DRM_E_FAIL);
		}
 	}
ErrorExit:
	DX_VOS_MemFree(pbPassword);
	DX_VOS_MemFree(pbData);
	return dr;
}

DRM_RESULT TestDRM_SST_SetData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL,Key2, *pKey2=NULL;
	DRM_BYTE *pbPassword=NULL;
 	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iContextNull=0, iHDSContextNull=0;
	DRM_DWORD cbData=0;
	DRM_BYTE *pbData=NULL;

	/*at least 7 arguments.*/  
 	if(argc<7){
		Log("Trace", "\t\tFrom TestDRM_SST_SetData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}

   	if(argv[0]==NULL)
 		iContextNull=1;
 
 	if(argv[1]!=NULL){
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[1], min(DX_VOS_StrLen(argv[1]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

 	if(argv[2]!=NULL){
		DX_VOS_MemSet(Key2.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key2.rgb, argv[2], min(DX_VOS_StrLen(argv[2]) + 1, DRM_ID_SIZE));
		pKey2 = &Key2;
	} 

 	if(argv[3]!=NULL){
 		pbPassword=(DRM_BYTE*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[3])+1);
		if(!pbPassword)
			ChkDR(DRM_E_FAIL);
		DX_VOS_FastMemCpy(pbPassword, argv[3],DX_VOS_StrLen(argv[3])+1);			 
	} 

 	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atoi(argv[4]);
  
	if(argv[5]==NULL)
 		iHDSContextNull=1;
 
 	if(argv[6]!=NULL){
		cbData=DX_VOS_StrLen(argv[6])+1;
 		ChkMem(pbData=(DRM_BYTE*)DX_VOS_MemMalloc(cbData));
	 	DX_VOS_FastMemCpy(pbData, argv[6], cbData);
	}
 
	ChkDR(DRM_SST_SetData(iContextNull>0?NULL:&g_oContext[0], pKey1,pKey2, pbPassword, iSecType, iHDSContextNull>0?NULL:g_pHdsContext,pbData, cbData));
   	 
ErrorExit:
	DX_VOS_MemFree(pbPassword);
	DX_VOS_MemFree(pbData);
	return dr;
}

DRM_RESULT TestDRM_SST_OpenKeyTokens(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL,Key2, *pKey2=NULL;
	DRM_BYTE *pbPassword=NULL;
 	DRM_DWORD dwFlags=0;
	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iContextNull=0, iHDSContextNull=0, iContextNum=0;
 
	/*at least 7 arguments.*/  
 	if(argc<7){
		Log("Trace", "\t\tFrom TestDRM_SST_OpenKeyTokens: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
  
  	if(argv[0]==NULL)
 		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);

 	if(argv[1]!=NULL){
		/*16 bytes*/
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[1], min(DX_VOS_StrLen(argv[1]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

 	if(argv[2]!=NULL){
		/*16 bytes*/
		DX_VOS_MemSet(Key2.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key2.rgb, argv[2], min(DX_VOS_StrLen(argv[2]) + 1, DRM_ID_SIZE));
		pKey2 = &Key2;
	} 

 	if(argv[3]!=NULL){
		/*20 bites*/
 		pbPassword=(DRM_BYTE*)DX_VOS_MemMalloc(SHA_DIGEST_LEN);
		if(!pbPassword)
			ChkDR(DRM_E_FAIL);
		if(DX_VOS_StrCmp(argv[3],"Password")){
			DX_VOS_FastMemCpy(pbPassword, argv[3],min(DX_VOS_StrLen(argv[3]) + 1, SHA_DIGEST_LEN));			 
		}
		else{
			DX_VOS_FastMemCpy(pbPassword, g_szSecStorePassword,SHA_DIGEST_LEN);			 
		}
	} 

	/*secure flag*/
 	dwFlags=(DRM_DWORD)OEM_atol(argv[4]);
 
 	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atoi(argv[5]);
 
	if(argv[6]==NULL)
 		iHDSContextNull=1;
 
	ChkDR(DRM_SST_OpenKeyTokens(iContextNull>0?NULL:&g_oContext[iContextNum], pKey1,pKey2, pbPassword, dwFlags, iSecType, iHDSContextNull>0?NULL:g_pHdsContext));
  
ErrorExit:
	if(pbPassword)
		DX_VOS_MemFree(pbPassword);
	return dr;
}

DRM_RESULT TestDRM_SST_GetTokenValue(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	TOKEN myToken;   
	DRM_WCHAR pwszAttr[256]={0};
 	DRM_CONST_STRING pwszAttribute;
	int iContextNull=0, iContextNum=0;

	/*At least 4 arguments
		argv[0]: g_oContext;
		argv[1]: attribute name;
		argv[2]: token type;
		argv[3]: taken value to be verified
	*/
 	if(argc<4){
		Log("Trace", "\t\tFrom TestDRM_SST_GetTokenValue: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
  	
	if(argv[0]==NULL)
		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);

	/*attribute name*/
 	if(argv[1]!=NULL){
  		OEM_mbstowcs(pwszAttr, argv[1], DX_VOS_StrLen(argv[1])+1);
		pwszAttribute.cchString=DRM_wcslen(pwszAttr)+1;
		pwszAttribute.pwszString=pwszAttr;
	}
	else{
		pwszAttribute.pwszString=NULL;
		pwszAttribute.cchString=0;
	}
	 
   	ChkDR(DRM_SST_GetTokenValue(iContextNull>0?NULL:&g_oContext[iContextNum], &pwszAttribute, &myToken));
  
     /*verify the results*/
	if(argv[2]!=NULL && argv[3]!=NULL){
		if(TOKEN_LONG==(DRM_EXPR_TOKEN_TYPE)OEM_atoi(argv[2])){
			if(myToken.TokenType!=TOKEN_LONG || myToken.val.lValue!=(DRM_LONG)OEM_atol(argv[3])){
				ChkDR(DRM_E_FAIL);
			}
		}
		else if(TOKEN_FUNCTION==(DRM_EXPR_TOKEN_TYPE)OEM_atoi(argv[2])){
			if(myToken.TokenType!=TOKEN_FUNCTION || myToken.val.fnValue!=(DRM_DWORD)OEM_atoi(argv[3])){
				ChkDR(DRM_E_FAIL);
			}
		}
		else if(TOKEN_DATETIME==(DRM_EXPR_TOKEN_TYPE)OEM_atoi(argv[2])){
			if(myToken.TokenType!=TOKEN_DATETIME || !DRM_UI64Eql(myToken.val.u64DateTime, DRM_UI64(OEM_atol(argv[3])))){
				ChkDR(DRM_E_FAIL);
			}
		}
		else if(TOKEN_STRING==(DRM_EXPR_TOKEN_TYPE)OEM_atoi(argv[2])){
			DX_VOS_MemSet(pwszAttr,0,sizeof(pwszAttr));
			OEM_mbstowcs(pwszAttr, argv[3],DX_VOS_StrLen(argv[3])+1 );
			if(myToken.TokenType!=TOKEN_STRING || DRM_wcsncmp(myToken.val.stringValue.pwszString,pwszAttr,myToken.val.stringValue.cchString)){
				ChkDR(DRM_E_FAIL);
			}
		}
	}

ErrorExit:
   	return dr;
}

DRM_RESULT TestDRM_SST_SetTokenValue(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	TOKEN myToken;   
	DRM_WCHAR pwszAttr[256]={0}, pwszString[256]={0};
 	DRM_CONST_STRING pwszAttribute;
	int iContextNull=0, iContextNum=0;
  
	/*At least 4 arguments
		argv[0]: g_oContext;
		argv[1]: attribute name;
		argv[2]: token type;
		argv[3]: taken value to be set
	*/
 	if(argc<4){
		Log("Trace", "\t\tFrom TestDRM_SST_GetTokenValue: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
 
	if(argv[0]==NULL)
		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);

	/*attribute name*/
 	if(argv[1]!=NULL){
		OEM_mbstowcs(pwszAttr, argv[1], DX_VOS_StrLen(argv[1])+1);
		pwszAttribute.cchString=DRM_wcslen(pwszAttr)+1;
		pwszAttribute.pwszString=pwszAttr;
	}
	else{
		pwszAttribute.pwszString=NULL;
		pwszAttribute.cchString=0;
	}
	 
	/*set token type and values*/
	myToken.TokenType=(DRM_EXPR_TOKEN_TYPE)OEM_atoi(argv[2]);
	if(myToken.TokenType==TOKEN_LONG){
		myToken.val.lValue=(DRM_LONG)OEM_atol(argv[3]);
	}
	else if(myToken.TokenType==TOKEN_FUNCTION){
		myToken.val.fnValue=(DRM_EXPR_FUNCTION_TYPE)OEM_atoi(argv[3]);
	}
	else if(myToken.TokenType==TOKEN_DATETIME){
 		myToken.val.u64DateTime=DRM_UI64(OEM_atol(argv[3]));
	}
	else if(myToken.TokenType==TOKEN_STRING){
		if(argv[3]!=NULL){
			OEM_mbstowcs(pwszString, argv[3], DX_VOS_StrLen(argv[3])+1);
			myToken.val.stringValue.cchString=DRM_wcslen(pwszString)+1;
			myToken.val.stringValue.pwszString=pwszString;
		}
		else{
			myToken.val.stringValue.pwszString=NULL;
			myToken.val.stringValue.cchString=0;
		}
 	}

   	ChkDR(DRM_SST_SetTokenValue(iContextNull>0?NULL:&g_oContext[iContextNum], &pwszAttribute, &myToken));
      
ErrorExit:
   	return dr;
}
 
DRM_RESULT TestDRM_SST_GetAllData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
  	DRM_BYTE *pbData=NULL;
	DRM_DWORD cbData=0;
 	int iContextNull=0, iSizeNull=0, iContextNum=0;

	/*at least 4 arguments.*/  
	if(argc<4){
		Log("Trace", "\t\tFrom TestDRM_SST_GetAllData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
 
	if(argv[0]==NULL)
		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);

  	if(argv[1]!=NULL){
		cbData=DX_VOS_StrLen(argv[2])+1;
 		ChkMem(pbData=(DRM_BYTE*)DX_VOS_MemMalloc(cbData));
	 	DX_VOS_FastMemCpy(pbData, argv[2], cbData);
	}
	if(argv[3]==NULL)
		iSizeNull=1;

	dr=DRM_SST_GetAllData(iContextNull>0?NULL:&g_oContext[iContextNum], pbData, iSizeNull>0?NULL:&cbData);
 	if (dr==DRM_E_BUFFERTOOSMALL){
		DX_VOS_MemFree(pbData);
		ChkMem(pbData = DX_VOS_MemMalloc(cbData + 1));
	}
	else{
		ChkDR(dr);
	}
	ChkDR(DRM_SST_GetAllData(iContextNull>0?NULL:&g_oContext[iContextNum], pbData, &cbData));

ErrorExit:
	DX_VOS_MemFree(pbData);
  	return dr;
}

DRM_RESULT TestDRM_SST_CloseKey(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
  	int iContextNull=0, iHDSContextNull=0, iContextNum=0;
 
	/*at least 2 arguments.*/  
 	if(argc<2){
		Log("Trace", "\t\tFrom TestDRM_SST_CloseKey: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}

   	if(argv[0]==NULL)
 		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);
 
  	if(argv[1]==NULL)
 		iHDSContextNull=1;
 
	ChkDR(DRM_SST_CloseKey(iContextNull>0?NULL:&g_oContext[iContextNum], iHDSContextNull>0?NULL:g_pHdsContext));
  
ErrorExit:
 	return dr;
}

DRM_RESULT TestDRM_SST_DeleteKey(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL,Key2, *pKey2=NULL;
	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iContextNull=0, iHDSContextNull=0, iContextNum=0;
 
	/*at least 5 arguments.*/  
 	if(argc<5){
		Log("Trace", "\t\tFrom TestDRM_SST_DeleteKey: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}

   	if(argv[0]==NULL)
 		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[0]);
 
	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atoi(argv[1]);
 
 	if(argv[2]!=NULL){
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[2], min(DX_VOS_StrLen(argv[2]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

 	if(argv[3]!=NULL){
		DX_VOS_MemSet(Key2.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key2.rgb, argv[3], min(DX_VOS_StrLen(argv[3]) + 1, DRM_ID_SIZE));
		pKey2 = &Key2;
	} 
   
	if(argv[4]==NULL)
 		iHDSContextNull=1;

	ChkDR(DRM_SST_DeleteKey(iContextNull>0?NULL:&g_oContext[iContextNum],iSecType,pKey1,pKey2, iHDSContextNull>0?NULL:g_pHdsContext));
  
ErrorExit:
 	return dr;
}

DRM_RESULT TestDRM_SST_OpenEnumerator(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL;
  	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iEnumContextNull=0, iHDSContextNull=0;
 
	/*at least 4 arguments.*/  
 	if(argc<4){
		Log("Trace", "\t\tFrom TestDRM_SST_OpenEnumerator: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
 
	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atoi(argv[0]);
 
	if(argv[1]!=NULL){
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[1], min(DX_VOS_StrLen(argv[1]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

  	if(argv[2]==NULL)
 		iEnumContextNull=1;
 
	if(argv[3]==NULL)
 		iHDSContextNull=1;

	ChkDR(DRM_SST_OpenEnumerator(iSecType,pKey1,iEnumContextNull>0?NULL:&g_oSecEnumContext,iHDSContextNull>0?NULL:g_pHdsContext, FALSE));
  
ErrorExit:
 	return dr;
}

DRM_RESULT TestDRM_SST_EnumNext(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL;
  	DRM_DWORD cbNum=0; 
 	int iEnumContextNull=0,iSizeNull=0;
 
	/*at least 4 arguments.*/
 	if(argc<4){
		Log("Trace", "\t\tFrom TestDRM_SST_EnumNext: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
 
  	if(argv[0]==NULL)
 		iEnumContextNull=1;
 
	if(argv[1]!=NULL){
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[1], min(DX_VOS_StrLen(argv[1]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	}

	if(argv[2]==NULL){
		iSizeNull=1;
	}
	else
		cbNum=OEM_atol(argv[2]);

 	ChkDR(DRM_SST_EnumNext(iEnumContextNull>0?NULL:&g_oSecEnumContext,pKey1, iSizeNull>0?NULL:&cbNum));
  
	/*verify key value*/
	if(argv[3]!=NULL){
		if(DX_VOS_StrNCmp((const DxChar*)pKey1->rgb,argv[3], min(DX_VOS_StrLen(argv[3]) + 1, DRM_ID_SIZE))){
			ChkDR(DRM_E_FAIL);
		}
	}

ErrorExit:
 	return dr;

}
DRM_RESULT _iTestGetDevCertValues( DRM_BB_CONTEXT *pcontextBBX )
{
	DRM_RESULT dr;
	DRM_BYTE rgbBuffer[MAX_DEVICE_CERT_SIZE];    
	DRM_CONST_STRING dstrDevCert;

	DSTR_FROM_PB( &dstrDevCert, rgbBuffer, SIZEOF(rgbBuffer) );

	/*blackbox initialized */
	ChkDR( DRM_DDC_GetDeviceCertificate( (DRM_STRING*)&dstrDevCert, 0, &pcontextBBX->CryptoContext ) );
	ChkDR( DRM_DCP_LoadPropertiesCache( &dstrDevCert, &pcontextBBX->cachedCertValues, &pcontextBBX->CryptoContext ) );
	ChkDR( DRM_BBX_Initialize( pcontextBBX ) );

ErrorExit:
	return dr;
}

DRM_RESULT TestDRM_SST_CreateGlobalStorePassword(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	DRM_BB_CONTEXT oBBContext;
 
	ChkDR(_iTestGetDevCertValues(&oBBContext));
	ChkDR( DRM_BBX_Initialize( &oBBContext ) );
	ChkDR(DRM_SST_CreateGlobalStorePassword(g_szSecStorePassword, (DRM_BYTE*)&oBBContext));
 
ErrorExit:
	DRM_BBX_Shutdown(&oBBContext);
 	return dr;
}

DRM_RESULT TestDRM_SST_CreateLicenseStatePassword(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	DRM_BB_CONTEXT oBBContext;
	DRM_LID localLID;

	ChkDR(_iTestGetDevCertValues(&oBBContext));
	ChkDR( DRM_BBX_Initialize( &oBBContext ) );
	if(argv[0]!=NULL){
		DX_VOS_FastMemCpy(localLID.rgb, argv[0], min(DX_VOS_StrLen(argv[0])+1, DRM_ID_SIZE));
	}

    ChkDR(DRM_SST_CreateLicenseStatePassword(&localLID, g_szSecStorePassword, (DRM_BYTE*)&oBBContext));
 
ErrorExit:
	DRM_BBX_Shutdown(&oBBContext);
 	return dr;
}

DRM_RESULT TestDRM_SST_OpenAndLockSlot(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	DRM_ID Key1, *pKey1=NULL,Key2, *pKey2=NULL;
	DRM_BYTE *pbPassword=NULL;
 	DRM_DWORD dwFlags=0;
	eDRM_SECURE_STORE_TYPE iSecType=0x1;
 	int iContextNull=0, iHDSContextNull=0, iContextNum=0;
 
	/*at least 7 arguments.*/  
 	if(argc<7){
		Log("Trace", "\t\tFrom TestDRM_SST_OpenAndLockSlot: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
	}
  
	if(argv[0]==NULL)
 		iHDSContextNull=1;
 
 	/*secure type*/
	iSecType=(eDRM_SECURE_STORE_TYPE)OEM_atoi(argv[1]);
 
 	if(argv[2]!=NULL){
		/*16 bytes*/
		DX_VOS_MemSet(Key1.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key1.rgb, argv[2], min(DX_VOS_StrLen(argv[2]) + 1, DRM_ID_SIZE));
		pKey1 = &Key1;
	} 

 	if(argv[3]!=NULL){
		/*16 bytes*/
		DX_VOS_MemSet(Key2.rgb, 0, DRM_ID_SIZE);
		DX_VOS_FastMemCpy(Key2.rgb, argv[3], min(DX_VOS_StrLen(argv[3]) + 1, DRM_ID_SIZE));
		pKey2 = &Key2;
	} 

 	if(argv[4]!=NULL){
		/*20 bites*/
 		pbPassword=(DRM_BYTE*)DX_VOS_MemMalloc(SHA_DIGEST_LEN);
		if(!pbPassword)
			ChkDR(DRM_E_FAIL);
		if(DX_VOS_StrCmp(argv[4],"Password")){
			DX_VOS_FastMemCpy(pbPassword, argv[4],min(DX_VOS_StrLen(argv[4]) + 1, SHA_DIGEST_LEN));			 
		}
		else{
			DX_VOS_FastMemCpy(pbPassword, g_szSecStorePassword,SHA_DIGEST_LEN);			 
		}
	} 

	/*secure flag*/
 	dwFlags=(DRM_DWORD)OEM_atol(argv[5]);
 
	if(argv[6]==NULL)
 		iContextNull=1;
	else
		iContextNum=OEM_atoi(argv[6]);
  
    
	ChkDR(DRM_SST_OpenAndLockSlot(iHDSContextNull>0?NULL:g_pHdsContext, iSecType,pKey1,pKey2,pbPassword,dwFlags,iContextNull>0?NULL:&g_oContext[iContextNum],NULL));
  
ErrorExit:
	if(pbPassword)
		DX_VOS_MemFree(pbPassword);

	return dr;
}

DRM_RESULT TestDRM_SST_SetLockedData(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	int iContextNum=0;
	DRM_DWORD cbData=0;
	DRM_BYTE *pbData=NULL;

	iContextNum=OEM_atoi(argv[0]);
	if(argv[1]!=NULL){
		cbData=DX_VOS_StrLen(argv[1])+1;
 		ChkMem(pbData=(DRM_BYTE*)DX_VOS_MemMalloc(cbData));
	 	DX_VOS_FastMemCpy(pbData, argv[1], cbData);
	}
 
	ChkDR(DRM_SST_SetLockedData(&g_oContext[iContextNum],cbData, pbData));
  
ErrorExit:
	DX_VOS_MemFree(pbData);
  	return dr;
}

DRM_RESULT TestDRM_SST_GetLockedData(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	int iContextNum=0;
	DRM_DWORD cbData=0;
	DRM_BYTE *pbData=NULL;

	iContextNum=OEM_atoi(argv[0]);
	dr=DRM_SST_GetLockedData(&g_oContext[iContextNum],pbData, &cbData);
 	if (dr==DRM_E_BUFFERTOOSMALL){
 		ChkMem(pbData = DX_VOS_MemMalloc(cbData + 1));
	}
	else{
		ChkDR(dr);
	}
	ChkDR(DRM_SST_GetLockedData(&g_oContext[iContextNum], pbData, &cbData));
  
	/*verify the data*/
	if(argv[1]!=NULL){
		if(DX_VOS_StrNCmp((char*)pbData,argv[1], DX_VOS_StrLen(argv[1]))){
			ChkDR(DRM_E_FAIL);
		}
 	}
ErrorExit:
	DX_VOS_MemFree(pbData);
  	return dr;
}
 

DRM_RESULT TestDRM_SST_CloseLockedSlot(long argc, char **argv)
{
 	DRM_RESULT dr=DRM_SUCCESS;
	int iContextNum=0;

	iContextNum=OEM_atoi(argv[0]);
	ChkDR(DRM_SST_CloseLockedSlot(&g_oContext[iContextNum]));
  
ErrorExit:
  	return dr;
}

  
DRM_RESULT SST_PreTestCase(long lTCID, char *strTCName)
{
	DRM_RESULT dr;
	const DRM_WCHAR devCertTemplate[] = { TWO_BYTES('d','e'), TWO_BYTES('v','c'),
									 	  TWO_BYTES('e','r'), TWO_BYTES('t','t'),
										  TWO_BYTES('e','m'), TWO_BYTES('p','l'),
										  TWO_BYTES('a','t'), TWO_BYTES('e','.'),
										  TWO_BYTES('d','a'), TWO_BYTES('t','\0') };
	const DRM_WCHAR priv[] = { TWO_BYTES('p','r'), TWO_BYTES('i','v'), TWO_BYTES('.','d'),
							   TWO_BYTES('a','t'), TWO_BYTES('\0',0) };

	DRM_CONST_STRING dstrStoreName;
	RemoveDRMFile(RMFILE_STORE);
    /*DX: added full path*/
	ChkDR(SetDeviceEnv(devCertTemplate, priv, TRUE));
	tGetDeviceStorePathname(&dstrStoreName);
    ChkDR(OpenHDS(&g_pHdsContext, dstrStoreName.pwszString, FALSE));
ErrorExit:
  	return dr;
}

DRM_RESULT SST_PostTestCase(long lTCID, char *strTCName)
{
	DRM_RESULT dr;
 	ChkDR(CloseHDS(g_pHdsContext));
	g_pHdsContext = NULL;
	RemoveDRMFile(RMFILE_STORE);
ErrorExit:
	return dr;
}

static DRM_RESULT WrapTestRun(long lTCID, DRM_BOOL fPreTestRun)
{
	return DRM_SUCCESS;
}

/*
BEGIN_APIMAP(testsecstore_ansi, "TestSecStore")
	API_ENTRY(TestDRM_SST_GetData)
	API_ENTRY(TestDRM_SST_SetData)
	API_ENTRY(TestDRM_SST_OpenEnumerator)
	API_ENTRY(TestDRM_SST_EnumNext)
	API_ENTRY(TestDRM_SST_OpenKeyTokens)
	API_ENTRY(TestDRM_SST_GetTokenValue)
 	API_ENTRY(TestDRM_SST_SetTokenValue)
	API_ENTRY(TestDRM_SST_GetAllData)
	API_ENTRY(TestDRM_SST_CloseKey)
	API_ENTRY(TestDRM_SST_DeleteKey)
	API_ENTRY(TestDRM_SST_Initialize)
	API_ENTRY(TestDRM_SST_CreateGlobalStorePassword)
	API_ENTRY(TestDRM_SST_CreateLicenseStatePassword)
	API_ENTRY(TestDRM_SST_OpenAndLockSlot)
	API_ENTRY(TestDRM_SST_SetLockedData)
	API_ENTRY(TestDRM_SST_GetLockedData)
	API_ENTRY(TestDRM_SST_CloseLockedSlot)
END_APIMAP
*/

